# validate_kernel_manifest.py
import json, os, numpy as np

MAN = "data/kernels/kernel_manifest.json"

def sha256(p):
    import hashlib
    h = hashlib.sha256()
    with open(p, "rb") as f:
        for ch in iter(lambda: f.read(1<<20), b""):
            h.update(ch)
    return h.hexdigest()

def main():
    man = json.load(open(MAN,"r",encoding="utf-8"))
    ok = True
    seen = set()
    for row in man["kernels"]:
        g, L, path = row["gauge"], int(row["L"]), row["path"]
        key = (g,L)
        if key in seen:
            print(f"[FAIL] duplicate (gauge,L) in manifest: {key}"); ok=False
        seen.add(key)
        if not os.path.exists(path):
            print(f"[FAIL] missing kernel file: {path}"); ok=False; continue
        arr = np.load(path); exp = 2*L*L
        if arr.size != exp:
            print(f"[FAIL] size mismatch {path}: {arr.size} != {exp}"); ok=False
        h = sha256(path)
        if h != row["sha256"]:
            print(f"[FAIL] hash mismatch {path}: {h[:12]} != {row['sha256'][:12]}"); ok=False
    if ok: print("[OK] kernel manifest validated")
    raise SystemExit(0 if ok else 2)

if __name__ == "__main__":
    main()
